// Header File
// Created 27/12/2003; 23:38:50
//Gestion du Bonus Colle

//Temps d'attente
#define BONUS_COLLE_TIME		7

//Prototypes
void Bonus_DesactivateColle (unsigned char item);

//Active le bonus colle sur racket
void Bonus_ActivateColle (unsigned char item)
{
	//Si bonus existe
	if (Racket [item]->colle) return;
	
	Racket [item]->colle=TRUE;
	Racket [item]->COUNTER_BONUS_COLLE=0;
}

//Colle une Bille sur la raquette
void Bonus_RacketColle (unsigned char n_racket,unsigned char n_bille)
{	
	//Sauvegarde des vitesses des Billes
	Bille [n_bille]->save_speed=Bille [n_bille]->speed;
	
	//Bille coll sur raquette n
	Bille [n_bille]->n_racket=n_racket;
	
	//Applique collage
	ChangeBilleSpeed (n_bille, 0);
	Bille [n_bille]->sticked=TRUE;
	
	//Coordonnes de collage
	Bille [n_bille]->x_colle=Bille [n_bille]->xpos-Racket [n_racket]->xpos;
	
	//Direction
	Bille [n_bille]->y_colle=Bille [n_bille]->ypos-Racket [n_racket]->ypos;
}

//Ractualis l'emplacement des Billes
void Bonus_BilleInRacketColle (void)
{
	for (int i=0;i<nbrBille;i++)
	{
		for (int j=0;j<nbrRacket;j++)
		{
			//Si Bille sur la raquette
			if ((Racket [j]->colle) && (Bille [i]->sticked) && (Bille [i]->n_racket==j))
			{
				ChangeBillePos (i, Racket [j]->xpos+Bille [i]->x_colle, Racket [j]->ypos+Bille [i]->y_colle);
				break;
			}
		}
	}
}

//Dcolle Bille
void Bonus_RacketNoSticked (unsigned char item)
{
	//Restaure vitesse
	ChangeBilleSpeed (item, Bille [item]->save_speed);
	
	//Remet compteur  zro
	Racket [Bille [item]->n_racket]->COUNTER_BONUS_COLLE=0;
	
	//Flag sticked dsactiv
	Bille [item]->sticked=FALSE;
}

void Bonus_RacketNoStickedAllBilles (unsigned char item)
{
	//Parcours billes
	for (int i=0; i<nbrBille; i++)
	{
		if (Bille [i]->n_racket==item)
			Bonus_RacketNoSticked (i);
	}
}

//Bonus Colle gestion touches
void KEYS_BonusColle (unsigned char item)
{	
	//Si plus de joueur
	if ((item==0xFF) || !StartGameForHumain0) return;
	
	//Si touche et Bonus activ
	if (Racket [item]->colle && (_keytest2 (RR_ENTER1) || _keytest2 (RR_ENTER2) || _keytest2 (RR_2ND)))
	{
		//Parcours Bille
		for (int i=0;i<nbrBille;i++)
		{
			//Si bille colle
			if ((Bille [i]->sticked) && (Bille [i]->n_racket==item))
			{
				//Dcolle la bille
				Bonus_RacketNoSticked (i);
				
				//Remet compteur  zro
				Racket [item]->COUNTER_BONUS_COLLE=0;
											
				//Si commence joueur
				if (!EndAnimForHumain0 && StartGameForHumain0 && !LanceBille)
				{
					Bonus_DesactivateColle (item);
					LanceBille=TRUE;
				}
			}
		}
	}
}

//Efface Bonus Colle
void Bonus_DesactivateColle (unsigned char item)
{	
	//Parcours Bille
	for (int i=0;i<nbrBille;i++)
	{
		//Si bille colle
		if ((Bille [i]->sticked) && (Bille [i]->n_racket==item))
		{
			//Dcolle la bille
			Bonus_RacketNoSticked (i);
			
			//Remet compteur  zro
			Racket [item]->COUNTER_BONUS_COLLE=0;
						
			//Remet compteur  zro
			Racket [item]->COUNTER_BONUS_COLLE=0;
		}
	}
	
	//Efface Bonus Colle
	Racket [item]->colle=FALSE;
}